<?php if ( ! class_exists( 'GPUR_Save_Site_Ratings' ) ) {
	class GPUR_Save_Site_Ratings {

		public function __construct() {
			add_action( 'save_post', array( $this, 'save_rating' ) );	
		}

		public function save_rating( $post_id ) {
				
			if ( 'disabled' === get_post_meta( $post_id, 'gp_override_average_rating', true ) ) {
			
				$ratings = get_post_meta( $post_id, 'gpur_site_rating_data', true );
			
				if ( ! empty( $ratings ) && is_array( $ratings ) ) {				
		
					// Get correct meta keys
					$site_rating_meta_key = gpur_get_site_rating( $post_id );

					$count = count( $ratings );
				
					$each_rating = 0;
				
					foreach( $ratings as $rating ) {
						$each_rating += $rating;
					}
					$updated_avg_rating_value = $each_rating / $count;	
					$old_avg_rating_value = get_post_meta( $post_id, $site_rating_meta_key, true );
				
					update_post_meta( $post_id, $site_rating_meta_key, $updated_avg_rating_value, $old_avg_rating_value );
					
				}
				
			}
	
		}

	}	
}
if ( is_admin() ) {
	new GPUR_Save_Site_Ratings();
}